// AgentOutputDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "AgentOutputDlg.h"
#include "IBFlowView.h"
#include "XISLOutputAgent.h"
#include "XISLVar.h"
#include "XISLVarList.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TYPE_BALLOON 0
#define TYPE_SPEECH  1

extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CAgentOutputDlg _CAO


CAgentOutputDlg::CAgentOutputDlg(CXISLOutputAgent *pOutputTag,CXISLTag *pCurrentTag,BOOL bNew,CWnd* pParent /*=NULL*/)
	: CDialog(CAgentOutputDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAgentOutputDlg)
	m_strAgentName = _T("");
	m_PosRadioGlp = -1;
	m_strAgentSpeech = _T("");
	m_nAgentMoveX = 0;
	m_nAgentMoveY = 0;
	m_strAgentMoveObj = _T("");
	m_nEventGlp = -1;
	//}}AFX_DATA_INIT
	m_pParent = (CIBFlowView*)pParent;
	m_pOutputTag = pOutputTag;
	m_pCurrentTag = pCurrentTag;
	m_pTextList = NULL;
	m_bNew = bNew;
	Create(CAgentOutputDlg::IDD,pParent);
}


void CAgentOutputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAgentOutputDlg)
	DDX_Control(pDX, IDC_AGENT_SCHAR_COMBO, m_AgentSCharComb);
	DDX_Control(pDX, IDC_AGENT_SPEECH_EDIT, m_editAgentSpeech);
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Control(pDX, IDC_AGENT_OBJPATH_EDIT, m_AOObjctEditCtrl);
	DDX_Control(pDX, IDC_AGENT_ACTION_COMBO, m_ActionCombo);
	DDX_Control(pDX, IDC_AGENT_CONTROL, m_AgentCtl);
	DDX_Text(pDX, IDC_AGENT_NAME_EDIT, m_strAgentName);
	DDX_Radio(pDX, IDC_AGENT_POSLEFT_RADIO, m_PosRadioGlp);
	DDX_Text(pDX, IDC_AGENT_SPEECH_EDIT, m_strAgentSpeech);
	DDX_Text(pDX, IDC_AGENT_MOVEX_EDIT, m_nAgentMoveX);
	DDV_MinMaxInt(pDX, m_nAgentMoveX, 0, 999);
	DDX_Text(pDX, IDC_AGENT_MOVEY_EDIT, m_nAgentMoveY);
	DDV_MinMaxInt(pDX, m_nAgentMoveY, 0, 999);
	DDX_Text(pDX, IDC_AGENT_OBJPATH_EDIT, m_strAgentMoveObj);
	DDX_Radio(pDX, IDC_RADIO_CREATE, m_nEventGlp);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAgentOutputDlg, CDialog)
	//{{AFX_MSG_MAP(CAgentOutputDlg)
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_AGENT_DEMO_BUTTON, OnAgentDemoButton)
	ON_BN_CLICKED(IDC_AGENT_ACTION_RADIO, OnAgentActionRadio)
	ON_BN_CLICKED(IDC_AGENT_BALLON_RADIO, OnAgentBallonRadio)
	ON_BN_CLICKED(IDC_AGENT_MOVEO_RADIO, OnAgentMoveoRadio)
	ON_BN_CLICKED(IDC_AGENT_MOVEP_RADIO, OnAgentMovepRadio)
	ON_BN_CLICKED(IDC_AGENT_SCHAR_RADIO, OnAgentScharRadio)
	ON_BN_CLICKED(IDC_AGENT_SPEECH_RADIO, OnAgentSpeechRadio)
	ON_CBN_SELCHANGE(IDC_AGENT_SCHAR_COMBO, OnSelchangeAgentScharCombo)
	ON_CBN_SELCHANGE(IDC_AGENT_ACTION_COMBO, OnSelchangeAgentActionCombo)
	ON_EN_CHANGE(IDC_AGENT_SPEECH_EDIT, OnChangeAgentSpeechEdit)
	ON_EN_UPDATE(IDC_AGENT_MOVEX_EDIT, OnUpdateAgentMovexEdit)
	ON_EN_UPDATE(IDC_AGENT_MOVEY_EDIT, OnUpdateAgentMoveyEdit)
	ON_BN_CLICKED(IDC_AGENT_POSRIGHT_RADIO, OnAgentPosrightRadio)
	ON_BN_CLICKED(IDC_AGENT_POSMID_RADIO, OnAgentPosmidRadio)
	ON_BN_CLICKED(IDC_AGENT_POSLEFT_RADIO, OnAgentPosleftRadio)
	ON_EN_UPDATE(IDC_AGENT_OBJPATH_EDIT, OnUpdateAgentObjpathEdit)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//void CFSMOutputDlg::InitDlgItem()
//@\@FeRg[\
//@F
//ԂlF
void CAgentOutputDlg::InitDlgItem()
{
	GetDlgItem(IDC_AGENT_ACTION_COMBO)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_SCHAR_COMBO)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_SPEECH_EDIT)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_MOVEX_EDIT)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_MOVEY_EDIT)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_POSLEFT_RADIO)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_POSMID_RADIO)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_POSRIGHT_RADIO)->EnableWindow(FALSE);
	GetDlgItem(IDC_AGENT_OBJPATH_EDIT)->EnableWindow(FALSE);
	m_lbVar.EnableWindow(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CAgentOutputDlg bZ[W nh
void CAgentOutputDlg::PostNcDestroy() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	m_AgentCtl.DestroyWindow();
	m_pParent->m_bDropOK = TRUE;
	m_pParent->m_pAODlg = NULL;

	if(m_pTextList)
		delete m_pTextList;

	delete this;
//	CDialog::PostNcDestroy();
}

void CAgentOutputDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();

	COleVariant vEmpty;
	COleVariant vText;

	CString strParam;
	switch(m_nEventGlp)
	{
	case 0:
		m_pOutputTag->SetAttribute(ID_AGENTEVENT_CREATE);
		break;
	case 1:
		if(m_ActionCombo.GetWindowTextLength() == 0)
		{
			m_AgentChar.Play("Confused");
			vText.SetString("ANV΂̂H",VT_BSTR);
			m_AgentChar.Speak(vText,vEmpty);
			vText.Clear();
			return;
		}
		else
		{
			m_ActionCombo.GetWindowText(strParam);
			m_pOutputTag->SetAttribute(ID_AGENTEVENT_ACTION,strParam);
//			((CIBFlowView*)m_pParent)->InsertOutputAgent(nType,nEvent,m_nAgentType,strParam);
		}
		break;
	case 2:
		if(m_AgentSCharComb.GetWindowTextLength() == 0)
		{
			m_AgentChar.Play("Decline");
			vText.SetString("N̐^΂́H",VT_BSTR);
			m_AgentChar.Speak(vText,vEmpty);
			vText.Clear();
			return;
		}
		else
		{
			m_pOutputTag->SetAttribute(ID_AGENTEVENT_SCHAR,"",m_AgentSCharComb.GetCurSel());
			//m_AgentSCharComb.GetWindowText(strParam);
//			((CIBFlowView*)m_pParent)->InsertOutputAgent(nType,nEvent,m_nAgentType,"",m_AgentSCharComb.GetCurSel());
		}
		break;
	case 3:
		if(m_strAgentSpeech.IsEmpty())
		{
			m_AgentChar.Play("Uncertain");
			vText.SetString("𒝂āH",VT_BSTR);
			m_AgentChar.Speak(vText,vEmpty);
			vText.Clear();
			return;
		}
		else
		{
			m_pOutputTag->SetAttribute(ID_AGENTEVENT_SPEECH,m_strAgentSpeech);
			if(!CreateTextList())
				return;
			m_pOutputTag->SetText(m_pTextList);
//			((CIBFlowView*)m_pParent)->InsertOutputAgent(nType,nEvent,m_nAgentType,m_strAgentSpeech);
		}
		break;
	case 4:
		if(m_strAgentSpeech.IsEmpty())
		{
			m_AgentChar.Play("Uncertain");
			vText.SetString("𒝂āH",VT_BSTR);
			m_AgentChar.Speak(vText,vEmpty);
			vText.Clear();
			return;
		}
		else
		{
			m_pOutputTag->SetAttribute(ID_AGENTEVENT_BALLOON,m_strAgentSpeech);
			if(!CreateTextList())
				return;
			m_pOutputTag->SetText(m_pTextList);
//			((CIBFlowView*)m_pParent)->InsertOutputAgent(nType,nEvent,m_nAgentType,m_strAgentSpeech);
		}
		break;
	case 5:
		m_pOutputTag->SetAttribute(ID_AGENTEVENT_MOVEXY,"",m_nAgentMoveX,m_nAgentMoveY);
//		((CIBFlowView*)m_pParent)->InsertOutputAgent(nType,nEvent,m_nAgentType,"",m_nAgentMoveX,m_nAgentMoveY);
		break;
	case 6:
		if(m_AOObjctEditCtrl.GetWindowTextLength() == 0)
		{
			m_AgentChar.Play("DontRecognize");
			vText.SetString("ǂ̃IuWFNgɍs΂́H",VT_BSTR);
			m_AgentChar.Speak(vText,vEmpty);
			vText.Clear();
			return;
		}
		else
		{
			m_AOObjctEditCtrl.GetWindowText(strParam);
			m_pOutputTag->SetAttribute(ID_AGENTEVENT_MOVEOBJ,strParam,m_PosRadioGlp);
//			((CIBFlowView*)m_pParent)->InsertOutputAgent(nType,nEvent,m_nAgentType,strParam,m_PosRadioGlp);
		}
		break;
	default:
		CRect rect;
		GetWindowRect(&rect);
		m_AgentChar.MoveTo(rect.left+120,rect.top+rect.Height()/2-70,vEmpty);
		m_AgentChar.GestureAt(rect.left+rect.Width()/2,rect.top+rect.Height()/2);
		vText.SetString("ǉeIĂ",VT_BSTR);
		m_AgentChar.Speak(vText,vEmpty);
		m_AgentChar.MoveTo(rect.left+280,rect.top-50,vEmpty);
		return;
	}

	if(m_bNew)
		m_pParent->InsertOutputAgent(m_pOutputTag->GetName());
	else
	{
		CXISLDoc *pDoc = (CXISLDoc*)m_pParent->GetDocument();
		pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
		DestroyWindow();
	}
}


void CAgentOutputDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	
}

void CAgentOutputDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	if(m_pTextList)
	{
		while(!m_pTextList->IsEmpty())
		{
			CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
			if(pVar->IsDummy())
				delete pVar;
		}
	}

	if(m_bNew)
	{
		delete m_pOutputTag;
		m_pOutputTag = NULL;
	}

	m_pParent->ResetViewItem();
	DestroyWindow();
//	CDialog::OnCancel();
}

BOOL CAgentOutputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	//G[WFg̐L
	m_mCharacterMap.SetAt( "brother",	"{473C5E04-00BA-11d0-A8F3-00003916A201}" );	//ZiftHj
	m_mCharacterMap.SetAt( "sister",	"{473C5E01-00BA-11d0-A8F3-00003916A201}" );	//o
	m_mCharacterMap.SetAt( "boy",		"{473C5E03-00BA-11d0-A8F3-00003916A201}" );	//V
	m_mCharacterMap.SetAt( "girl",		"{473C5E00-00BA-11d0-A8F3-00003916A201}" );	//
	m_mCharacterMap.SetAt( "g-father",	"{473C5E05-00BA-11d0-A8F3-00003916A201}" );	//
	m_mCharacterMap.SetAt( "g-mother",	"{473C5E02-00BA-11d0-A8F3-00003916A201}" );	//k
	m_mCharacterMap.SetAt( "robotA",	"{473C5E06-00BA-11d0-A8F3-00003916A201}" );	//{A
	m_mCharacterMap.SetAt( "robotB",	"{473C5E07-00BA-11d0-A8F3-00003916A201}" );	//{B
	m_mCharacterMap.SetAt( "robotC",	"{473C5E08-00BA-11d0-A8F3-00003916A201}" );	//{C

	m_strAgentName = AGENT_NAME[m_pOutputTag->GetName()];

	COleVariant vFile;
	COleVariant vEmpty;

	vFile.SetString(AGENT_ACS[m_pOutputTag->GetName()],VT_BSTR);
	m_AgentCtl.GetCharacters().Load(m_strAgentName,vFile);
	m_AgentChar = m_AgentCtl.GetCharacters().Character(m_strAgentName);
	m_AgentChar.Show(vEmpty);

	//ANVXg̓o^
	HRESULT hRes;
	DWORD					dwRetrieved;
	VARIANT					vAnimName;
	IUnknown			   *punkAnimNames;
	IEnumVARIANT		   *pevAnimNames;

	m_AgentChar.GetAnimationNames().GetProperty(DISPID_NEWENUM, VT_UNKNOWN, (void *)&punkAnimNames);
	hRes = punkAnimNames->QueryInterface(IID_IEnumVARIANT, (LPVOID *)&pevAnimNames);

	punkAnimNames->Release();
	
	if (SUCCEEDED(hRes)) {
		while (TRUE) {
			if (pevAnimNames->Next(1, &vAnimName, &dwRetrieved) != NOERROR)
				break;
			// Hmmmm
			_ASSERT(dwRetrieved > 0);
			_ASSERT(vAnimName.vt == VT_BSTR);
			_ASSERT(vAnimName.bstrVal != NULL);
				
			CString pszAnimName(vAnimName.bstrVal);
				
			m_ActionCombo.AddString((LPCTSTR)pszAnimName);
				
			VariantClear(&vAnimName);
		}
		pevAnimNames->Release();
	}

//	m_PosRadioGlp = 0;
	UpdateData(FALSE);

	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 70;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-70;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
	
	CXISLDialogTag *pDTag = (CXISLDialogTag*)pExcItem->GetParentDialogTag();
	nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
	CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
	nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
	if(!pRTag->IsAppRoot() && g_pAppRootTag)
		g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);

	InitDlgItem();

	int nPoint[2];
	CString strParam;
	switch(m_pOutputTag->m_nOutputEvent)
	{
	case ID_AGENTEVENT_CREATE:
		m_nEventGlp = 0;
		break;
	case ID_AGENTEVENT_DESTROY:
	case ID_AGENTEVENT_SHOW:
	case ID_AGENTEVENT_HIDE:
		break;
	case ID_AGENTEVENT_MOVEXY:
		m_nEventGlp = 5;
		m_pOutputTag->GetMovePoint(nPoint);
		m_nAgentMoveX = nPoint[0];
		m_nAgentMoveY = nPoint[1];
		UpdateData(FALSE);
		OnAgentMovepRadio();
		break;
	case ID_AGENTEVENT_MOVEOBJ:
		m_nEventGlp = 6;
		m_PosRadioGlp = m_pOutputTag->GetMoveObj(m_strAgentMoveObj);
		UpdateData(FALSE);
		OnAgentMoveoRadio();
		break;
	case ID_AGENTEVENT_SCHAR:
		m_nEventGlp = 2;
		m_AgentSCharComb.SetCurSel(m_AgentSCharComb.FindString(-1,SPEECH_CHARACTOR[m_pOutputTag->GetCharactor()]));
		UpdateData(FALSE);
		OnAgentScharRadio();
		break;
	case ID_AGENTEVENT_ACTION:
		m_nEventGlp = 1;
		m_ActionCombo.SetCurSel(m_ActionCombo.FindString(-1,m_pOutputTag->GetActionName()));
		UpdateData(FALSE);
		OnAgentActionRadio();
		break;
	case ID_AGENTEVENT_SPEECH:
		m_nEventGlp = 3;
		m_strAgentSpeech = m_pOutputTag->GetText(strParam);
		UpdateData(FALSE);
		OnAgentSpeechRadio();
		break;
	case ID_AGENTEVENT_BALLOON:
		m_nEventGlp = 4;
		m_strAgentSpeech = m_pOutputTag->GetText(strParam);
		UpdateData(FALSE);
		OnAgentBallonRadio();
		break;
	}

	UpdateData(FALSE);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

BOOL CAgentOutputDlg::CreateTextList()
{
	UpdateData();

	if(m_pTextList == NULL)
		m_pTextList = new CPtrList;

	m_strAgentSpeech.Replace("@"," ");
	int nStart = 0;
	CXISLVar *pText;
	CString strVarName;
	BOOL bOK = TRUE;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	while(1)
	{
		if(m_strAgentSpeech.IsEmpty())
			break;
		nStart = m_strAgentSpeech.Find(" $",0);
		
		if(nStart == -1)
		{
			pText = new CXISLVar;
			pText->SetAttribute(m_strAgentSpeech,"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			break;
		}

		if(nStart != 0)
		{
			pText = new CXISLVar;
			pText->SetAttribute(m_strAgentSpeech.Left(nStart),"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			m_strAgentSpeech.Delete(0,nStart);
		}
		else
		{
			nStart = m_strAgentSpeech.Find(" ",nStart+1);
			if(nStart == -1)
				strVarName = m_strAgentSpeech;
			else
				strVarName = m_strAgentSpeech.Left(nStart);
			strVarName.Remove('$');
			strVarName.Remove(' ');
			CXISLVar *pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				AfxMessageBox("݂Ȃϐw肳܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			m_strAgentSpeech.Delete(0,nStart+1);
			m_pTextList->AddTail(pVar);
			pVar->ReferCount(TRUE);
		}
	}

	if(!bOK)
	{
		while(!m_pTextList->IsEmpty())
		{
			CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
			if(pVar->IsDummy())
				delete pVar;
			else
				pVar->ReferCount(FALSE);
		}
	}

	return bOK;
}

void CAgentOutputDlg::SetActionPalam()
{
	UpdateData();

	CString strPalam;
	m_ActionCombo.GetWindowText(strPalam);
	m_strAgentOutput = "<output type=\"agent\" event=\"action\">\r\n";
	m_strAgentOutput += "<![CDATA[\r\n<param name=\"name\">";
	m_strAgentOutput += m_strAgentName;
	m_strAgentOutput += "</param>\r\n";
	m_strAgentOutput += "<param name=\"action-name\">";
	m_strAgentOutput += strPalam;
	m_strAgentOutput += "</param>\r\n]]>\r\n</output>\r\n";

	UpdateData(FALSE);
}

void CAgentOutputDlg::SetSCharPalam()
{
	UpdateData();

	CString strPalam;
	m_AgentSCharComb.GetWindowText(strPalam);
	m_strAgentOutput = "<output type=\"agent\" event=\"character\">\r\n";
	m_strAgentOutput += "<![CDATA[\r\n<param name=\"name\">";
	m_strAgentOutput += m_strAgentName;
	m_strAgentOutput += "</param>\r\n";
	m_strAgentOutput += "<param name=\"voice\">";
	m_strAgentOutput += strPalam;
	m_strAgentOutput += "</param>\r\n]]>\r\n</output>\r\n";

	UpdateData(FALSE);
}

void CAgentOutputDlg::SetSpeakPalam(int nType)
{
	UpdateData();

	if(nType == TYPE_SPEECH)
		m_strAgentOutput = "<output type=\"agent\" event=\"speech\">\r\n";
	else
		m_strAgentOutput = "<output type=\"agent\" event=\"text\">\r\n";
	m_strAgentOutput += "<![CDATA[\r\n<param name=\"name\">";
	m_strAgentOutput += m_strAgentName;
	m_strAgentOutput += "</param>\r\n";
	m_strAgentOutput += "<param name=\"text\">\r\n";
	m_strAgentOutput += m_strAgentSpeech;
	m_strAgentOutput += "\r\n</param>\r\n]]>\r\n</output>\r\n";

	UpdateData(FALSE);
}

void CAgentOutputDlg::SetMovePointPalam()
{
	UpdateData();

	char chPoint[5];
	m_strAgentOutput = "<output type=\"agent\" event=\"move\">\r\n";
	m_strAgentOutput += "<![CDATA[\r\n<param name=\"name\">";
	m_strAgentOutput += m_strAgentName;
	m_strAgentOutput += "</param>\r\n";
	m_strAgentOutput += "<param name=\"x\">";
	m_strAgentOutput += itoa(m_nAgentMoveX,chPoint,10);
	m_strAgentOutput += "</param>\r\n";
	m_strAgentOutput += "<param name=\"y\">";
	m_strAgentOutput += itoa(m_nAgentMoveY,chPoint,10);
	m_strAgentOutput += "</param>\r\n]]>\r\n</output>\r\n";

	UpdateData(FALSE);
}

void CAgentOutputDlg::SetMoveObjectPalam()
{
	UpdateData();

	CString strPalam;
	m_AOObjctEditCtrl.GetWindowText(strPalam);
	CString strPos;
	switch(m_PosRadioGlp)
	{
	case 0:
		strPos = "left";
		break;
	case 1:
		strPos = "center";
		break;
	case 2:
		strPos = "right";
		break;
	}
	m_strAgentOutput = "<output type=\"agent\" event=\"move\">\r\n";
	m_strAgentOutput += "<![CDATA[\r\n<param name=\"name\">";
	m_strAgentOutput += m_strAgentName;
	m_strAgentOutput += "</param>\r\n";
	m_strAgentOutput += "<param name=\"object\">\r\n";
	m_strAgentOutput += strPalam;
	m_strAgentOutput += "</param>\r\n";
	m_strAgentOutput += "<param name=\"pos\">";
	m_strAgentOutput += strPos;
	m_strAgentOutput += "</param>\r\n]]>\r\n</output>\r\n";

	UpdateData(FALSE);
}

void CAgentOutputDlg::OnAgentDemoButton() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();

	if(m_strAgentOutput.IsEmpty())
	{
		COleVariant vEmpty;
		COleVariant vText;
		vText.SetString("w肵Ă",VT_BSTR);

		m_AgentChar.Speak(vText,vEmpty);
		return;
	}

	int i=0;
	int nStart=0;
	int nEnd=0;
	CString strEvent;
	CString strName;
	CString strValue;
	int nX=0,nY=0;
	CRect objRect;
	COleVariant vEmpty;
	COleVariant vText;

	i=m_strAgentOutput.Find("event",0);
	nStart = m_strAgentOutput.Find("\"",i);
	nStart++;
	nEnd = m_strAgentOutput.Find("\"",nStart);
	strEvent = m_strAgentOutput.Mid(nStart,nEnd-nStart);

	i=0;
	while(1)
	{
		i = m_strAgentOutput.Find("<param",i);
		if(i==-1)
			return;

		i = m_strAgentOutput.Find("name",i);
		nStart = m_strAgentOutput.Find("\"",i);
		nStart++;
		nEnd = m_strAgentOutput.Find("\"",nStart);
		strName = m_strAgentOutput.Mid(nStart,nEnd-nStart);

		nStart = m_strAgentOutput.Find(">",nEnd);
		nStart++;
		nEnd = m_strAgentOutput.Find("<",nStart);
		strValue = m_strAgentOutput.Mid(nStart,nEnd-nStart);
		
		if(strName.Compare("action-name")==0)
			m_AgentChar.Play(strValue);
		else if(strName.Compare("voice")==0)
		{
			m_AgentChar.SetLanguageID(0x411);
			CString strCharacterId;
			if( !m_mCharacterMap.Lookup( strValue,strCharacterId ) )
				//LN^[̒TɎs
				m_AgentChar.SetTTSModeID( "473C5E04-00BA-11d0-A8F3-00003916A201" );
			else
				m_AgentChar.SetTTSModeID( (LPCSTR)strCharacterId );

			vText.SetString("\\Map=\"\\Spd(20)\\\"=\"`\"\\",VT_BSTR);
			m_AgentChar.Speak(vText,vEmpty);
			vText.Clear();
		}
		else if(strName.Compare("text")==0)
		{
			int nStart=0,nEnd;
			while(1)
			{
				nStart = strValue.Find(" $",nStart);
				if(nStart == -1)
					break;
				nEnd = strValue.Find(" ",nStart+1);
				if(nEnd == -1)
					nEnd = strValue.GetLength();
				strValue.Delete(nStart,nEnd-nStart);
				strValue.Insert(nStart," ϐ");
			}
			vText.SetString(strValue.Mid(2,strValue.GetLength()-4),VT_BSTR);
			if(strEvent.Compare("speech")==0)
				m_AgentChar.Speak(vText,vEmpty);
		}
		else if(strName.Compare("x")==0)
			nX = atoi(strValue);
		else if(strName.Compare("y")==0)
		{
			nY = atoi(strValue);
			m_AgentChar.MoveTo(nX,nY,vEmpty);
		}
		else if(strName.Compare("object")==0)
		{
			CRect rect;
			m_AOObjctEditCtrl.GetWindowRect(&rect);
			nX = rect.left;
			nY = rect.top - m_AgentChar.GetHeight();
			m_AgentChar.MoveTo(nX,nY,vEmpty);
			m_AgentChar.Play("GestureDown");
			vText.SetString("̃pXIuWFNgɈړ܂",VT_BSTR);
			m_AgentChar.Speak(vText,vEmpty);
			vText.Clear();
		}
/*		else if(strName.Compare("position")==0)
		{
			if(strValue.Compare("left")==0)
			{
				nX = objRect.left - (int)m_AgentChar.GetWidth();
				nY = objRect.top;
			}
			else if(strValue.Compare("center")==0)
			{
				nX = objRect.left+objRect.Width()/2 - m_AgentChar.GetWidth()/2;
				nY = objRect.top+objRect.Height()/2 - m_AgentChar.GetHeight()/2;
			}
			else if(strValue.Compare("right")==0)
			{
				nX = objRect.right;
				nY = objRect.top;
			}
			m_AgentChar.MoveTo(nX,nY,vEmpty);
		}
*/
		i = nEnd + 1;
	}
}

void CAgentOutputDlg::CantInsert()
{
	COleVariant vEmpty;
	COleVariant vText;
	CString strText = "\\Map=\"GNX`FWANV\"=\"exchangeaction\"\\";
	strText += "ɂ\\Map=\"AEgvbg\"=\"output\"\\͑}łȂ";
	vText.SetString(strText,VT_BSTR);

	m_AgentChar.Speak(vText,vEmpty);
}

void CAgentOutputDlg::OnAgentActionRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_AGENT_ACTION_COMBO)->EnableWindow();
	SetActionPalam();
}

void CAgentOutputDlg::OnAgentBallonRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_AGENT_SPEECH_EDIT)->EnableWindow();
	m_lbVar.EnableWindow();
	SetSpeakPalam(TYPE_BALLOON);
}

void CAgentOutputDlg::OnAgentSpeechRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_AGENT_SPEECH_EDIT)->EnableWindow();
	m_lbVar.EnableWindow();
	SetSpeakPalam(TYPE_SPEECH);	
}

void CAgentOutputDlg::OnAgentMoveoRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_AGENT_POSLEFT_RADIO)->EnableWindow();
	GetDlgItem(IDC_AGENT_POSMID_RADIO)->EnableWindow();
	GetDlgItem(IDC_AGENT_POSRIGHT_RADIO)->EnableWindow();
	GetDlgItem(IDC_AGENT_OBJPATH_EDIT)->EnableWindow(FALSE);
	SetMoveObjectPalam();
}

void CAgentOutputDlg::OnAgentMovepRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_AGENT_MOVEX_EDIT)->EnableWindow();
	GetDlgItem(IDC_AGENT_MOVEY_EDIT)->EnableWindow();
	SetMovePointPalam();
}

void CAgentOutputDlg::OnAgentScharRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_AGENT_SCHAR_COMBO)->EnableWindow();
	SetSCharPalam();
}

void CAgentOutputDlg::OnSelchangeAgentScharCombo() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetSCharPalam();
}

void CAgentOutputDlg::OnSelchangeAgentActionCombo() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetActionPalam();
}

void CAgentOutputDlg::OnChangeAgentSpeechEdit() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetSpeakPalam(TYPE_SPEECH);
}

void CAgentOutputDlg::OnUpdateAgentMovexEdit() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_UPDATE tOt EM_SETEVENTMASK
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetMovePointPalam();
}

void CAgentOutputDlg::OnUpdateAgentMoveyEdit() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_UPDATE tOt EM_SETEVENTMASK
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetMovePointPalam();
}

void CAgentOutputDlg::OnAgentPosrightRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetMoveObjectPalam();
}

void CAgentOutputDlg::OnAgentPosmidRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetMoveObjectPalam();
}

void CAgentOutputDlg::OnAgentPosleftRadio() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetMoveObjectPalam();
}

void CAgentOutputDlg::OnUpdateAgentObjpathEdit() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_UPDATE tOt EM_SETEVENTMASK
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetMoveObjectPalam();
}


void CAgentOutputDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		UpdateData();
		int nStart,nEnd;
		m_editAgentSpeech.GetSel(nStart,nEnd);

		if((nStart != 0) && (nStart != m_strAgentSpeech.GetLength()))
		{
			int nSpace1=0,nSpace2=0;
			while(1)
			{
				nSpace1 = m_strAgentSpeech.Find(" $",nSpace1);
				if(nSpace1 == -1)
					break;
				nSpace2 = m_strAgentSpeech.Find(" ",nSpace1+1);
				if(nSpace2 == -1)
					nSpace2 = m_strAgentSpeech.GetLength();

				if(nStart >= nSpace1 && nStart <= nSpace2)
				{
					nStart = nSpace2;
					break;
				}
				nSpace1 = nSpace2;
			}
		}

		CXISLVar *pVar = (CXISLVar*)item.lParam;
		CString strVarName;
		pVar->GetVarNameEx(strVarName);
		strVarName.Insert(0," $");
		strVarName += " ";
		m_strAgentSpeech.Insert(nStart,strVarName);
		UpdateData(FALSE);
		SetSpeakPalam(TYPE_SPEECH);
	}
	*pResult = 0;
}


BOOL CAgentOutputDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		if(pMsg->wParam == VK_RETURN)
			return TRUE;

		CWnd *pWnd = GetFocus();
		if(pWnd->GetDlgCtrlID() == IDC_AGENT_SPEECH_EDIT)
		{
			UpdateData();
			int nStart,nEnd;
			int nSpace1=0,nSpace2=0;
			switch( pMsg->wParam )
			{
			case VK_DELETE:
				m_editAgentSpeech.GetSel(nStart,nEnd);
				while(1)
				{
					nSpace1 = m_strAgentSpeech.Find(" $",nSpace1);
					if(nSpace1 == -1)
						break;
					nSpace2 = m_strAgentSpeech.Find(" ",nSpace1+1);
					if(nStart >= nSpace1 && nStart <= nSpace2)
					{
						m_strAgentSpeech.Delete(nSpace1,nSpace2-nSpace1);
						UpdateData(FALSE);
						break;
					}
					nSpace1 = nSpace2;
				}
				break;
			case VK_SPACE:
				return TRUE;
			case VK_BACK:
				m_editAgentSpeech.GetSel(nStart,nEnd);
				while(1)
				{
					nSpace1 = m_strAgentSpeech.Find(" $",nSpace1);
					if(nSpace1 == -1)
						break;
					nSpace2 = m_strAgentSpeech.Find(" ",nSpace1+1)+1;
					if(nStart >= nSpace1 && nStart <= nSpace2)
					{
						m_strAgentSpeech.Delete(nSpace1,nSpace2-nSpace1);
						UpdateData(FALSE);
						break;
					}
					nSpace1 = nSpace2;
				}
				break;				
			default:
				break;
			}
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}
